#!/bin/sh
#
# Drop all of the mysql stuff and recreate the mysql database

# Determine the product
PRODUCT=`cat /etc/barracuda/product` || PRODUCT=emailswitch

trap 'echo Removing "/tmp/nowatchdog..."; /bin/rm -f /tmp/nowatchdog' EXIT
echo $0 >> /tmp/nowatchdog

# Stop the log_monitor, mta and amavisd and make sure the
# watchdog is currently off
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl mta stop
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl amavisd stop
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl log_monitor stop

# Stop mysql and remove the mysql directory
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl mysql stop
/usr/bin/killall /usr/sbin/mysqld-max
/bin/rm -fr /mail/mysql

# Move the existing message log directory aside
/bin/mv /mail/mlog /mail/mlog.old

# Go ahead and re-creeate everything
/bin/mkdir -m 0777 /mail/mysql
/bin/chown mysql.mysql /mail/mysql
/bin/su mysql -c '/usr/bin/mysql_install_db --force'

# Make a copy of the proper mysql file
/bin/cp -f /etc/my.cnf /etc/my.cnf.saved

# Change the inno db buffer pool size for database re-creation
/bin/sed -i "s/set-variable = innodb_buffer_pool_size=.*/set-variable = innodb_buffer_pool_size=32M/;" /etc/my.cnf
/bin/sed -i "s/ibdata1:2G/ibdata1:1G/" /etc/my.cnf
# Startup mysql
/sbin/chkconfig mysql on
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl mysql start
sleep 15
set +e

# Move the proper mysql config back into place
/bin/mv -f /etc/my.cnf.saved /etc/my.cnf

# Start mysql again with the proper config now that it has the database created
/home/${PRODUCT}/code/firmware/current/bin/service_manager.pl mysql restart

# Refresh the per-user database from the configs as
# well as the config database
/home/emailswitch/code/firmware/current/web/cgi-bin/index.cgi > /dev/null 2>& 1
/home/emailswitch/code/firmware/current/bin/refresh_pu.pl

# Finished re-creating
echo "Reboot the system to fully complete the mysql re-creation!"
exit;
