#! /usr/bin/perl

package Barracuda::Utils;

use 5.004;
use Barracuda::Environment;
require MS_config;
require MS_config_io;
require MS_globals;

sub get_version {
  # get the version of an update we point to..
  # update_type is firmware/spamdef/virusdef
  # link_type is current/factory/previous
  my ($update_type, $link_type) = @_;
  $link_type ||= 'current';
  my $version = '';
  my $update_base_dir = "$Barracuda::Environment::path_home/code";
  if ($update_type ne 'firmware') {
    $update_base_dir = $Barracuda::Environment::path_home;;
  }
  if (readlink("$update_base_dir/$update_type/$link_type") =~ /\/([^\/]+)\/?$/ ||
      readlink("$update_base_dir/$update_type/$link_type") =~ /([\w\.]+)/) {
    $version = $1;
  }
  return $version;
}

sub get_build_date {
  # return the build data of the firmware
  if (open(BD, "$Barracuda::Environment::path_home/code/firmware/current/build_date")) {
      my $build_date = <BD>;
      my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
          localtime($build_date);
      close(BD);
      return sprintf "%d-%0.2d-%0.2d %0.2d:%0.2d:%0.2d",
          ($year+1900), $mday, ($mon+1), $hour, $min, $sec;
  }
  return '';
}

sub get_barracuda_model {
    return $MS_globals::model if $MS_globals::model;
    $MS_globals::model = '200';
    my $model_file = '/etc/cudamodel';
    if (-f $model_file)
    {
        open(MODEL, '/etc/cudamodel');
        $MS_globals::model = <MODEL>;
        $MS_globals::model =~ s/\W//g;
        close(MODEL);
    }
    return $MS_globals::model;
}

sub get_barracuda_serial {
    return $MS_globals::serial if $MS_globals::serial;

    my %serial_prefix = (
        '00', 'BAR-SF',
        '01', 'BAR-SF',
        '02', 'BAR-SF',
        '10', 'BAR-YF',
        '20', 'BAR-WF',
    );

    MS_config_io::read_config() unless %MS_globals::config;

    $MS_globals::serial="$serial_prefix{substr(get_barracuda_model(),1)}-$MS_globals::config{system_serial}";

}

sub get_iso_date_and_time {
    my $current_time = shift || time;
    my $format_string = shift || '%Y-%m-%d %H:%M:%S';

    # Get date
    my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime($current_time);
    
    # Go through format string
    $format_string =~ s/\%Y/($year + 1900)/eg;                                                              # Four-digit year
    $format_string =~ s/\%m/($mon + 1 < 10 ? '0' . ($mon + 1) : $mon + 1)/eg;                               # Two-digit month
    $format_string =~ s/\%d/($mday < 10 ? "0$mday" : $mday)/eg;                                             # Two-digit month day
    $format_string =~ s/\%H/($hour < 10 ? "0$hour" : $hour)/eg;                                             # Two-digit hour
    $format_string =~ s/\%M/($min < 10 ? "0$min" : $min)/eg;                                                # Two-digit minute
    $format_string =~ s/\%S/($sec < 10 ? "0$sec" : $sec)/eg;                                                # Two-digit second

    return $format_string;
}

sub get_iso_date {
    my $current_time = shift || time;
    my $format_string = shift || '%Y-%m-%d';
    
    # Wrapper for get_iso_date_and_time
    return get_iso_date_and_time($current_time, $format_string);
}

sub get_iso_time {
    my $current_time = shift || time;
    my $format_string = shift || '%H:%M:%S';
    
    # Wrapper for get_iso_date_and_time
    return get_iso_date_and_time($current_time, $format_string);
}

return 1;

__END__
